/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.users.users;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cyclos.model.Property;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum BasicProfileField implements ProfileField,
HasMessageKey
{
    FULL_NAME(ValueMatch.TEXT, UserDTO.NAME, "name", "fullName"),
    LOGIN_NAME(ValueMatch.EXACT, (Property<String, ?>)UserDTO.USERNAME, "username", "loginName", "login"),
    EMAIL(ValueMatch.EXACT, (Property<String, ?>)UserDTO.EMAIL, (Property<Boolean, ?>)UserDTO.HIDE_EMAIL, "email", "userEmail"),
    PHONE(ValueMatch.EXACT, "phone"),
    ADDRESS(ValueMatch.TEXT, "address"),
    ACCOUNT_NUMBER(ValueMatch.EXACT, "accountNumber"),
    IMAGE(ValueMatch.EXACT, "image");

    private final ValueMatch valueMatch;
    private final Property<String, ?> property;
    private final Property<Boolean, ?> hideProperty;
    private final List<String> aliases;

    public static BasicProfileField getByAlias(String string) {
        for (BasicProfileField basicProfileField : BasicProfileField.values()) {
            if (!basicProfileField.aliases.contains(string)) continue;
            return basicProfileField;
        }
        return null;
    }

    public static Set<BasicProfileField> simple() {
        EnumSet<BasicProfileField> enumSet = EnumSet.allOf(BasicProfileField.class);
        Iterator iterator = enumSet.iterator();
        while (iterator.hasNext()) {
            if (((BasicProfileField)iterator.next()).isSimple()) continue;
            iterator.remove();
        }
        return enumSet;
    }

    private BasicProfileField(ValueMatch valueMatch, Property<String, ?> property, Property<Boolean, ?> property2, String ... stringArray) {
        this.valueMatch = valueMatch;
        this.property = property;
        this.hideProperty = property2;
        this.aliases = Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    private BasicProfileField(ValueMatch valueMatch, Property<String, ?> property, String ... stringArray) {
        this(valueMatch, property, (Property<Boolean, ?>)null, stringArray);
    }

    private BasicProfileField(ValueMatch valueMatch, String ... stringArray) {
        this(valueMatch, (Property<String, ?>)null, (Property<Boolean, ?>)null, stringArray);
    }

    public boolean allowManagePrivacy() {
        return this == EMAIL || this == ADDRESS || this == PHONE;
    }

    public boolean canHide() {
        return this == EMAIL || this == PHONE || this == ADDRESS;
    }

    public String getAlias() {
        return (String)CollectionHelper.first(this.aliases);
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 5: {
                return GeneralKeys.Ui.PROFILE_FIELD_ACCOUNT_NUMBER;
            }
            case 4: {
                return GeneralKeys.Ui.PROFILE_FIELD_ADDRESS;
            }
            case 2: {
                return GeneralKeys.Ui.PROFILE_FIELD_EMAIL;
            }
            case 0: {
                return GeneralKeys.Ui.PROFILE_FIELD_FULL_NAME;
            }
            case 6: {
                return GeneralKeys.Ui.PROFILE_FIELD_IMAGE;
            }
            case 1: {
                return GeneralKeys.Ui.PROFILE_FIELD_LOGIN_NAME;
            }
            case 3: {
                return GeneralKeys.Ui.PROFILE_FIELD_PHONE;
            }
        }
        return null;
    }

    @Override
    public ValueMatch getValueMatch() {
        return this.valueMatch;
    }

    public MessageKey getVariableKey() {
        switch (this.ordinal()) {
            case 2: {
                return ContentManagementKeys.StaticContents.VARIABLE_USER_EMAIL;
            }
            case 5: {
                return ContentManagementKeys.StaticContents.VARIABLE_ACCOUNT_NUMBERS;
            }
        }
        return this.getMessageKey();
    }

    public String getVariableName() {
        return this == EMAIL ? "userEmail" : (String)CollectionHelper.first(this.aliases);
    }

    public Property<Boolean, ?> hideProperty() {
        return this.hideProperty;
    }

    public boolean isAllowedForOperator() {
        return this == FULL_NAME || this == LOGIN_NAME || this == PHONE || this == EMAIL;
    }

    public boolean isSimple() {
        return this.property != null;
    }

    public Property<String, ?> property() {
        return this.property;
    }

    public boolean readOnly() {
        return this == ACCOUNT_NUMBER;
    }
}

