/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.entitylogs;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.entitylogs.IEntityLogType;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum EntityLogType implements IEntityLogType,
HasMessageKey
{
    ACCOUNT_FEE(true),
    ACCOUNT_TYPE(true),
    AD(false),
    AD_CUSTOM_FIELD(true),
    AD_CUSTOM_FIELD_POSSIBLE_VALUE(true),
    ADDRESS(false),
    AGREEMENT(true),
    AUTHORIZATION_LEVEL(true),
    CHANNEL_CONFIGURATION(true),
    CONTACT_CUSTOM_FIELD(true),
    CONTACT_CUSTOM_FIELD_POSSIBLE_VALUE(true),
    CONTACT_INFO_FIELD(true),
    CONTACT_INFO_FIELD_POSSIBLE_VALUE(true),
    CONFIGURATION(true),
    CURRENCY(true),
    CUSTOM_BACKGROUND_TASK(true),
    CUSTOM_OPERATION(true),
    CUSTOM_OPERATION_FIELD(true),
    CUSTOM_OPERATION_FIELD_POSSIBLE_VALUE(true),
    CUSTOM_RECURRING_TASK(true),
    CUSTOM_SCRIPT(true),
    CUSTOM_WEB_SERVICE(true),
    CUSTOM_WIZARD(true),
    CUSTOM_WIZARD_FIELD(true),
    CUSTOM_WIZARD_FIELD_POSSIBLE_VALUE(true),
    CUSTOM_WIZARD_STEP(true),
    DOCUMENT_CUSTOM_FIELD(true),
    DOCUMENT_CUSTOM_FIELD_POSSIBLE_VALUE(true),
    EXPORT_FORMAT(true),
    IDENTITY_PROVIDER(true),
    LANGUAGE(true),
    OIDC_CLIENT(true),
    OPERATOR(false),
    PASSWORD_TYPE(true),
    PHONE(false),
    PRINCIPAL_TYPE(true),
    PRIVACY_CONTROL(true),
    PRODUCT(true),
    SYSTEM_RECORD(true),
    USER_RECORD(false),
    RECORD_CUSTOM_FIELD(true),
    RECORD_CUSTOM_FIELD_POSSIBLE_VALUE(true),
    RECORD_TYPE(true),
    SERVICE_INTERCEPTOR(true),
    SMS_OPERATION_CONFIGURATION(true),
    TOKEN(false),
    TRANSACTION_CUSTOM_FIELD(true),
    TRANSACTION_CUSTOM_FIELD_POSSIBLE_VALUE(true),
    TRANSFER_FEE(true),
    TRANSFER_FILTER(true),
    TRANSFER_TYPE(true),
    USER(false),
    USER_CUSTOM_FIELD(true),
    USER_CUSTOM_FIELD_POSSIBLE_VALUE(true),
    VOUCHER_CONFIGURATION(true),
    VOUCHER_CUSTOM_FIELD(true),
    VOUCHER_CUSTOM_FIELD_POSSIBLE_VALUE(true),
    VOUCHER_TYPE(true);

    private boolean system;

    public static Set<EntityLogType> getEntityLogTypes(boolean bl) {
        return Stream.of(EntityLogType.values()).filter(entityLogType -> entityLogType.system == bl && entityLogType != SYSTEM_RECORD).collect(Collectors.toSet());
    }

    private EntityLogType(boolean bl) {
        this.system = bl;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.EntityLogs.TYPE_ACCOUNT_FEE;
            }
            case 1: {
                return SystemKeys.EntityLogs.TYPE_ACCOUNT_TYPE;
            }
            case 2: {
                return SystemKeys.EntityLogs.TYPE_AD;
            }
            case 5: {
                return SystemKeys.EntityLogs.TYPE_ADDRESS;
            }
            case 6: {
                return SystemKeys.EntityLogs.TYPE_AGREEMENT;
            }
            case 7: {
                return SystemKeys.EntityLogs.TYPE_AUTHORIZATION_LEVEL;
            }
            case 8: {
                return SystemKeys.EntityLogs.TYPE_CHANNEL_CONFIGURATION;
            }
            case 13: {
                return SystemKeys.EntityLogs.TYPE_CONFIGURATION;
            }
            case 14: {
                return SystemKeys.EntityLogs.TYPE_CURRENCY;
            }
            case 20: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_SCRIPT;
            }
            case 29: {
                return SystemKeys.EntityLogs.TYPE_IDENTITY_PROVIDER;
            }
            case 31: {
                return SystemKeys.EntityLogs.TYPE_OIDC_CLIENT;
            }
            case 33: {
                return SystemKeys.EntityLogs.TYPE_PASSWORD_TYPE;
            }
            case 34: {
                return SystemKeys.EntityLogs.TYPE_PHONE;
            }
            case 35: {
                return SystemKeys.EntityLogs.TYPE_PRINCIPAL_TYPE;
            }
            case 37: {
                return SystemKeys.EntityLogs.TYPE_PRODUCT;
            }
            case 39: {
                return SystemKeys.EntityLogs.TYPE_USER_RECORD;
            }
            case 38: {
                return SystemKeys.EntityLogs.TYPE_SYSTEM_RECORD;
            }
            case 45: {
                return SystemKeys.EntityLogs.TYPE_TOKEN;
            }
            case 48: {
                return SystemKeys.EntityLogs.TYPE_TRANSFER_FEE;
            }
            case 50: {
                return SystemKeys.EntityLogs.TYPE_TRANSFER_TYPE;
            }
            case 51: {
                return SystemKeys.EntityLogs.TYPE_USER;
            }
            case 54: {
                return SystemKeys.EntityLogs.TYPE_VOUCHER_CONFIGURATION;
            }
            case 57: {
                return SystemKeys.EntityLogs.TYPE_VOUCHER_TYPE;
            }
            case 16: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_OPERATION;
            }
            case 21: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_WEB_SERVICE;
            }
            case 22: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_WIZARD;
            }
            case 25: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_WIZARD_STEP;
            }
            case 28: {
                return SystemKeys.EntityLogs.TYPE_EXPORT_FORMAT;
            }
            case 30: {
                return SystemKeys.EntityLogs.TYPE_LANGUAGE;
            }
            case 36: {
                return SystemKeys.EntityLogs.TYPE_PRIVACY_CONTROL;
            }
            case 42: {
                return SystemKeys.EntityLogs.TYPE_RECORD_TYPE;
            }
            case 43: {
                return SystemKeys.EntityLogs.TYPE_SERVICE_INTERCEPTOR;
            }
            case 44: {
                return SystemKeys.EntityLogs.TYPE_SMS_OPERATION_CONFIGURATION;
            }
            case 49: {
                return SystemKeys.EntityLogs.TYPE_TRANSFER_FILTER;
            }
            case 3: {
                return SystemKeys.EntityLogs.TYPE_AD_CUSTOM_FIELD;
            }
            case 9: {
                return SystemKeys.EntityLogs.TYPE_CONTACT_CUSTOM_FIELD;
            }
            case 11: {
                return SystemKeys.EntityLogs.TYPE_CONTACT_INFO_CUSTOM_FIELD;
            }
            case 17: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_OPERATION_CUSTOM_FIELD;
            }
            case 23: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_WIZARD_CUSTOM_FIELD;
            }
            case 26: {
                return SystemKeys.EntityLogs.TYPE_DOCUMENT_CUSTOM_FIELD;
            }
            case 40: {
                return SystemKeys.EntityLogs.TYPE_RECORD_CUSTOM_FIELD;
            }
            case 46: {
                return SystemKeys.EntityLogs.TYPE_TRANSACTION_CUSTOM_FIELD;
            }
            case 52: {
                return SystemKeys.EntityLogs.TYPE_USER_CUSTOM_FIELD;
            }
            case 55: {
                return SystemKeys.EntityLogs.TYPE_VOUCHER_CUSTOM_FIELD;
            }
            case 4: {
                return SystemKeys.EntityLogs.TYPE_AD_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 10: {
                return SystemKeys.EntityLogs.TYPE_CONTACT_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 12: {
                return SystemKeys.EntityLogs.TYPE_CONTACT_INFO_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 18: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_OPERATION_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 24: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_WIZARD_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 27: {
                return SystemKeys.EntityLogs.TYPE_DOCUMENT_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 41: {
                return SystemKeys.EntityLogs.TYPE_RECORD_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 47: {
                return SystemKeys.EntityLogs.TYPE_TRANSACTION_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 53: {
                return SystemKeys.EntityLogs.TYPE_USER_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 56: {
                return SystemKeys.EntityLogs.TYPE_VOUCHER_CUSTOM_FIELD_POSSIBLE_VALUE;
            }
            case 32: {
                return SystemKeys.EntityLogs.TYPE_OPERATOR;
            }
            case 15: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_BACKGROUND_TASK;
            }
            case 19: {
                return SystemKeys.EntityLogs.TYPE_CUSTOM_RECURRING_TASK;
            }
        }
        return null;
    }

    public boolean isConfiguration() {
        return this.system && this != SYSTEM_RECORD;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isUser() {
        return !this.system;
    }
}

