/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.messaging.messages;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum MessageDestination implements HasMessageKey
{
    USER(true),
    GROUP(false),
    BROKERED(false),
    SYSTEM(true);

    private boolean isSource;

    public static Set<MessageDestination> getMessageOrigins() {
        return Arrays.asList(MessageDestination.values()).stream().filter(MessageDestination::isSource).collect(Collectors.toSet());
    }

    private MessageDestination(boolean bl) {
        this.isSource = bl;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return MessagingKeys.Messages.SEND_TO_USER;
            }
            case 1: {
                return MessagingKeys.Messages.SEND_TO_GROUP;
            }
            case 2: {
                return MessagingKeys.Messages.SEND_TO_BROKERED;
            }
            case 3: {
                return MessagingKeys.Messages.SEND_TO_SYSTEM;
            }
        }
        return null;
    }

    public boolean isSource() {
        return this.isSource;
    }
}

