/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.banking.accounts;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;

public interface HasAccountTypes {
    public List<AccountTypeWithCurrencyVO> getAccountTypes();

    default public String getTransactionNumberPattern() {
        Set set = CollectionHelper.orEmpty(this.getAccountTypes()).stream().map(accountTypeWithCurrencyVO -> accountTypeWithCurrencyVO.getCurrency().getTransactionNumberPattern()).filter(Objects::nonNull).collect(Collectors.toSet());
        return set.size() == 1 ? (String)CollectionHelper.first(set) : null;
    }

    default public boolean hasTransactionNumber() {
        return CollectionHelper.orEmpty(this.getAccountTypes()).stream().anyMatch(accountTypeWithCurrencyVO -> StringHelper.isNotBlank((Object)accountTypeWithCurrencyVO.getCurrency().getTransactionNumberPattern()));
    }

    public void setAccountTypes(List<AccountTypeWithCurrencyVO> var1);
}

