/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.banking.accountfees;

import org.cyclos.model.banking.BankingKeys;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum UserAccountFeeStatus implements HasMessageKey
{
    PENDING,
    FAILED,
    SKIPPED,
    CHARGED;

    private static EnumMessageKeyResolver<UserAccountFeeStatus> resolverForUsersByStatus;

    public static EnumMessageKeyResolver<UserAccountFeeStatus> resolverForUsersByStatus() {
        if (resolverForUsersByStatus == null) {
            resolverForUsersByStatus = userAccountFeeStatus -> {
                switch (userAccountFeeStatus.ordinal()) {
                    case 0: {
                        return BankingKeys.AccountFees.USERS_BY_STATUS_PENDING;
                    }
                    case 1: {
                        return BankingKeys.AccountFees.USERS_BY_STATUS_FAILED;
                    }
                    case 2: {
                        return BankingKeys.AccountFees.USERS_BY_STATUS_SKIPPED;
                    }
                    case 3: {
                        return BankingKeys.AccountFees.USERS_BY_STATUS_CHARGED;
                    }
                }
                return null;
            };
        }
        return resolverForUsersByStatus;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return BankingKeys.AccountFees.USER_STATUS_PENDING;
            }
            case 1: {
                return BankingKeys.AccountFees.USER_STATUS_FAILED;
            }
            case 2: {
                return BankingKeys.AccountFees.USER_STATUS_SKIPPED;
            }
            case 3: {
                return BankingKeys.AccountFees.USER_STATUS_CHARGED;
            }
        }
        return null;
    }

    public boolean isFinished() {
        return this == CHARGED || this == SKIPPED;
    }
}

